using System;

using System.Collections.Generic;
using System.Text;

namespace KnihaJizd
{
    /// <summary>
    /// Třída pro reprezentaci jedné jízdy
    /// </summary>
    public class Jizda : System.Object
    {
        private int stav_tachometru_pocatecni;
        private int stav_tachometru_koncovy;
        private string jizda_odkud;
        private string jizda_kam;
        private DateTime datum;
        private string ridic;

        /// <summary>
        /// Konstruktor - vytvoření prázdné jízdy
        /// </summary>
        public Jizda()
        {
        }

        /// <summary>
        /// Konstruktor - vytvoření jízdy
        /// </summary>
        /// <param name="stav_pocatecni">Stav tachometru na počátku jízdy</param>
        /// <param name="stav_koncovy">Stav tachometru na konci jízdy</param>
        /// <param name="jizda_odkud">Výchozí místo</param>
        /// <param name="jizda_kam">Cílové místo</param>
        /// <param name="datum">Datum jízdy</param>
        /// <param name="ridic">Řidič</param>
        public Jizda(int stav_pocatecni, int stav_koncovy, string jizda_odkud, string jizda_kam, DateTime datum, string ridic)
        {
            this.stav_tachometru_pocatecni = stav_pocatecni;
            this.stav_tachometru_koncovy = stav_koncovy;
            this.jizda_odkud = jizda_odkud;
            this.jizda_kam = jizda_kam;
            this.datum = datum;
            this.ridic = ridic;
        }


        /// <summary>
        /// Vrátí / nastaví stav tachometru na počátku jízdy
        /// </summary>
        public int stavPocatecni
        {
            get
            {
                return this.stav_tachometru_pocatecni;
            }
            set
            {
                this.stav_tachometru_pocatecni = value;
            }
        }

        /// <summary>
        /// Vrátí / nastaví stav tachometru na konci jízdy
        /// </summary>
        public int stavKoncovy
        {
            get
            {
                return this.stav_tachometru_koncovy;
            }
            set
            {
                this.stav_tachometru_koncovy = value;
            }
        }

        /// <summary>
        /// Vrátí / nastaví výchozí místo jízdy
        /// </summary>
        public string jizdaOdkud
        {
            get
            {
                return this.jizda_odkud;
            }
            set
            {
                this.jizda_odkud = value;
            }
        }

        /// <summary>
        /// Vrátí / nastaví cílové místo jízdy
        /// </summary>
        public string jizdaKam
        {
            get
            {
                return this.jizda_kam;
            }
            set
            {
                this.jizda_kam = value;
            }
        }

        /// <summary>
        /// Vrátí / nastaví datum jízdy
        /// </summary>
        public DateTime Datum
        {
            get
            {
                return this.datum;
            }
            set
            {
                this.datum = value;
            }
        }

        /// <summary>
        /// Vrátí / nastaví řidiče
        /// </summary>
        public string Ridic
        {
            get
            {
                return this.ridic;
            }
            set
            {
                this.ridic = value;
            }
        }
    }
}
