using System;

using System.Collections.Generic;
using System.Text;

namespace KnihaJizd
{
    /// <summary>
    /// Třída pro reprezentaci jednoho tankování
    /// </summary>
    public class Tankovani : System.Object
    {
        private int stav_tachometru;
        private double palivo_nabrano;
        private double cena_celkova;
        private bool plna_nadrz = false;
        private DateTime datum;
        private string ridic;

        /// <summary>
        /// Konstruktor - vytvoření prázdného tankování
        /// </summary>
        public Tankovani()
        {
        }

        /// <summary>
        /// Konstruktor - vytvoření tankování
        /// </summary>
        /// <param name="stav_tachometru">Stav tachometru při tankování</param>
        /// <param name="palivo_nabrano">Objem nabraného paliva</param>
        /// <param name="cena_celkova">Cena za nabrané palivo</param>
        /// <param name="plna_nadrz">Byla brána plná nádrž?</param>
        /// <param name="datum">Datum tankování</param>
        /// <param name="ridic">Řidič</param>
        public Tankovani(int stav_tachometru, double palivo_nabrano, double cena_celkova, bool plna_nadrz, DateTime datum, string ridic)
        {
            this.stav_tachometru = stav_tachometru;
            this.palivo_nabrano = palivo_nabrano;
            this.plna_nadrz = plna_nadrz;
            this.cena_celkova = cena_celkova;
            this.datum = datum;
            this.ridic = ridic;
        }

        /// <summary>
        /// Vrátí / nastaví stav tachometru při tankování
        /// </summary>
        public int stavTachometru
        {
            get
            {
                return this.stav_tachometru;
            }
            set
            {
                this.stav_tachometru = value;
            }
        }

        /// <summary>
        /// Vrátí / nastaví objem nabraného paliva
        /// </summary>
        public double palivoNabrano
        {
            get
            {
                return this.palivo_nabrano;
            }
            set
            {
                this.palivo_nabrano = value;
            }
        }

        /// <summary>
        /// Vrátí / nastaví cenu za nabrané palivo
        /// </summary>
        public double cenaCelkova
        {
            get
            {
                return this.cena_celkova;
            }
            set
            {
                this.cena_celkova = value;
            }
        }

        /// <summary>
        /// Vrátí / nastaví zda byla brána plná nádrž
        /// </summary>
        public bool plnaNadrz
        {
            get
            {
                return this.plna_nadrz;
            }
            set
            {
                this.plna_nadrz = value;
            }
        }

        /// <summary>
        /// Vrátí / nastaví datum tankování
        /// </summary>
        public DateTime Datum
        {
            get
            {
                return this.datum;
            }
            set
            {
                this.datum = value;
            }
        }

        /// <summary>
        /// Vrátí / nastaví řidiče
        /// </summary>
        public string Ridic
        {
            get
            {
                return this.ridic;
            }
            set
            {
                this.ridic = value;
            }
        }
    }
}
