using System;

using System.Collections.Generic;
using System.Text;

namespace KnihaJizd
{
    /// <summary>
    /// Statická třída obsahující alogritmy
    /// </summary>
    static class Vypocty : System.Object
    {
        /// <summary>
        /// Výpočet průměrné spotřeby
        /// </summary>
        /// <param name="objem_nadrze">Objem nádrže automobilu</param>
        /// <param name="tankovani">Výčet tankování</param>
        /// <returns>Průměrná spotřeba l / 100 km</returns>
        public static double PrumernaSpotreba(double objem_nadrze, List<Tankovani> tankovani)
        {
            List<double> spotreba = new List<double>();

            //načtení ujetých kilometrů mezi tankováními a výpočet spotřeby
            for (int i = 1; i < tankovani.Count; i++)
            {
                int kilometry = tankovani[i].stavTachometru - tankovani[i - 1].stavTachometru;
                spotreba.Add(spotrebaNaSto(kilometry, tankovani[i].palivoNabrano));
            }

            return prumer(spotreba);
        }

        /// <summary>
        /// Výpočet průměru
        /// </summary>
        /// <param name="hodnoty">Výčet s hodnotami</param>
        /// <returns>Průměr hodnot z výčtu</returns>
        private static double prumer(List<double> hodnoty)
        {
            double soucet = 0;
            foreach (double cislo in hodnoty)
                soucet += cislo;
            //zaokrouhlení na dvě des. místa
            return Math.Round(soucet / (hodnoty.Count), 2);
        }

        /// <summary>
        /// Jednorázový výpočet spotřeby na 100 km
        /// </summary>
        /// <param name="ujeteKilometry">Ujeté kilometry</param>
        /// <param name="spotrebovanePalivo">Spotřebované palivo</param>
        /// <returns>Průměrná spotřeba l / 100 km</returns>
        private static double spotrebaNaSto(int ujeteKilometry, double spotrebovanePalivo)
        {
            return (100.0 / (double)ujeteKilometry) * spotrebovanePalivo;
        }
    }
}
