using System;

using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using System.IO;

namespace KnihaJizd
{
    /// <summary>
    /// Třída pro načítání dat z XML souboru info.xml
    /// </summary>
    class XMLAutomobil : System.Object
    {
        private XmlDocument xml;
        private string xml_soubor;
        private string auto;
 
        protected string nazev;
        protected string typ;
        protected string spz;
        protected string palivo;
        protected double objem_nadrze;
        
        /// <summary>
        /// Konstruktor
        /// </summary>
        /// <param name="auto">Načítaný automobil</param>
        public XMLAutomobil(DirectoryInfo auto)
        {
            this.xml = new XmlDocument();

            this.auto = auto.FullName;
            this.xml_soubor = this.auto + "\\info.xml";

            this.NactiXML();
        }

        /// <summary>
        /// Načtení souboru info.xml
        /// </summary>
        private void NactiXML()
        {
            if (!File.Exists(xml_soubor))
            {
                this.VytvorXML();
            }

            try
            {
                this.xml.Load(this.xml_soubor);
            }
            catch (XmlException e)
            {
                MessageBox.Show("Nelze načíst informace z XML.", "Chyba", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1);
            }

            this.ParsujXML();
        }

        /// <summary>
        /// Zpracování souboru info.xml
        /// </summary>
        private void ParsujXML()
        {
            XmlNodeList uvodni = this.xml.GetElementsByTagName("informace");

            foreach (XmlNode uzel in uvodni)
            {
                foreach (XmlNode udaje in uzel)
                {
                    switch (udaje.Name)
                    {
                        case "nazev":
                            this.nazev = udaje.InnerText;
                            break;

                        case "typ":
                            this.typ = udaje.InnerText;
                            break;

                        case "spz":
                            this.spz = udaje.InnerText;
                            break;

                        case "palivo":
                            this.palivo = udaje.InnerText;
                            break;

                        case "objem_nadrze":
                            this.objem_nadrze = Double.Parse(udaje.InnerText);
                            break;
                    }
                }
            }
        }

        /// <summary>
        /// Vytvoření prázdného souboru info.xml
        /// </summary>
        private void VytvorXML()
        {
            XmlDocument tmp = new XmlDocument();
            XmlNode hlavni, koren;

            hlavni = tmp.CreateNode(XmlNodeType.XmlDeclaration, "", "");
            tmp.AppendChild(hlavni);

            koren = tmp.CreateElement("informace");
            tmp.AppendChild(koren);

            StreamWriter write = new StreamWriter(this.xml_soubor, false, System.Text.Encoding.UTF8);

            tmp.Save(write);
            write.Close();
        }

//-------------------------------------------------------------------------------------------------------------------------------
        
        /// <summary>
        /// Vytvoří soubor info.xml a naplní ho předanými údaji
        /// </summary>
        /// <param name="auto">Cesta ke složece automobilu</param>
        /// <param name="nazev">Název automobilu</param>
        /// <param name="typ">Typ automobilu</param>
        /// <param name="spz">SPZ/RZ automobilu</param>
        /// <param name="palivo">Druh paliva automobilu</param>
        /// <param name="objem_nadrze">Objem nádrže automobilu</param>
        public static void VytvorAutomobil(string auto, string nazev, string typ, string spz, string palivo, double objem_nadrze)
        {
            XmlDocument xml = new XmlDocument();

            XmlNode deklarace = xml.CreateNode(XmlNodeType.XmlDeclaration, "", "");
            XmlNode koren = xml.CreateElement("informace");
            XmlNode Nnazev = xml.CreateElement("nazev");
            XmlNode Ntyp = xml.CreateElement("typ");
            XmlNode Nspz = xml.CreateElement("spz");
            XmlNode Npalivo = xml.CreateElement("palivo");
            XmlNode Nobjem_nadrze = xml.CreateElement("objem_nadrze");

            Nnazev.InnerText = nazev;
            Ntyp.InnerText = typ;
            Nspz.InnerText = spz;
            Npalivo.InnerText = palivo;
            Nobjem_nadrze.InnerText = objem_nadrze.ToString();

            koren.AppendChild(Nnazev);
            koren.AppendChild(Ntyp);
            koren.AppendChild(Nspz);
            koren.AppendChild(Npalivo);
            koren.AppendChild(Nobjem_nadrze);

            xml.AppendChild(deklarace);
            xml.AppendChild(koren);

            xml.Save(auto + "info.xml");
        }
    }
}
