using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace KnihaJizd
{
    /// <summary>
    /// Formulář pro rychlý přehled informací o automobilu
    /// </summary>
    public partial class frmAutomobil : Form
    {
        private DirectoryInfo auto;
        private Automobil automobil;
        
        /// <summary>
        /// Konstruktor - načte a zobrazí potřebná data
        /// </summary>
        /// <param name="auto"></param>
        public frmAutomobil(DirectoryInfo auto)
        {
            InitializeComponent();
            this.auto = auto;

            this.Nacti();
        }

        /// <summary>
        /// Načte a zobrazí data na obrazovce
        /// </summary>
        private void Nacti()
        {
            this.automobil = new Automobil(this.auto);
            this.Text = "Rychlý přehled - " + this.automobil.Nazev;

            this.lblNazev.Text = this.automobil.Nazev;

            this.lblJizdaEvidovanaVzdalenost.Text = this.automobil.JizdaEvidovanaVzdalenost + " km";
            this.lblJizdaDatumPosledni.Text = this.automobil.JizdaDatumPosledni;
            this.lblJizdaTrasaPosledni.Text = this.automobil.JizdaTrasaPosledni;

            this.lblTankovaniVzdalenostEvidovana.Text = this.automobil.TankovaniVzdalenostEvidovana + " km";
            this.lblTankovaniSpotrebaEvidovana.Text = this.automobil.TankovaniSpotrebaEvidovana + " l";
            this.lblTankovaniDatumPosledni.Text = this.automobil.TankovaniDatumPosledni;
            this.lblTankovaniPrumernaSpotreba.Text = this.automobil.TankovaniPrumernaSpotreba + " l / 100 km";
        }

        /// <summary>
        /// Menu Přidat jízdu - přidá jízdu
        /// </summary>
        private void mnuJizdaPridat_Click(object sender, EventArgs e)
        {
            frmJizdyEdit frm;

            if (this.automobil.jizdy.Count > 0)
                frm = new frmJizdyEdit(this.automobil.jizdy[this.automobil.jizdy.Count - 1].stavKoncovy, this.automobil.jizdy[this.automobil.jizdy.Count - 1].jizdaKam);
            else
                frm = new frmJizdyEdit();
            frm.ShowDialog();

            if (frm.Jizda != null)
            {
                this.automobil.vlozJizdu(frm.Jizda);
                this.Nacti();
            }
        }

        /// <summary>
        /// Menu Zobrazit jízdy - zobrazí všechny evidované jízdy
        /// </summary>
        private void mnuJizdaZobrazit_Click(object sender, EventArgs e)
        {
            frmJizdy frm = new frmJizdy(this.automobil.jizdy);
            frm.ShowDialog();

            this.automobil.nahradJizdy(frm.Jizdy);
            this.Nacti();
        }

        /// <summary>
        /// Menu Přidat tankování - přidá tankování
        /// </summary>
        private void mnuTankovaniPridat_Click(object sender, EventArgs e)
        {
            frmTankovaniEdit frm = new frmTankovaniEdit(this.automobil.tankovani.Count == 0);
            frm.ShowDialog();

            if (frm.Tankovani != null)
            {
                this.automobil.vlozTankovani(frm.Tankovani);
                this.Nacti();
            }
        }

        /// <summary>
        /// Menu Zobrazit tankování - zobrazí všechna evidovaná tankování
        /// </summary>
        private void mnuTankovaniZobrazit_Click(object sender, EventArgs e)
        {
            frmTankovani frm = new frmTankovani(this.automobil.tankovani);
            frm.ShowDialog();

            this.automobil.nahradTankovani(frm.Tankovani);
            this.Nacti();
        }

        /// <summary>
        /// Menu Zavřít - Zavře formulář
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void mnuZavrit_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
