using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace KnihaJizd
{
    /// <summary>
    /// Formulář pro přidání/upravení automobilu
    /// </summary>
	public partial class frmAutomobilEdit: Form
    {
        private string auto;
        private bool upravit;
        private bool zmena = false;

        /// <summary>
        /// Konstruktor - přidání automobilu
        /// </summary>
		public frmAutomobilEdit() {
			InitializeComponent();
			this.Text = "Přidat automobil";
			this.upravit = false;
		}

        /// <summary>
        /// Konstruktor - upravení automobilu
        /// </summary>
        /// <param name="auto">Upravovaný automobil</param>
		public frmAutomobilEdit(DirectoryInfo auto) {
			InitializeComponent();
			this.Text = "Upravit automobil " + auto.Name;
			this.upravit = true;
			this.auto = auto.FullName;

			Automobil upravovany = new Automobil(auto);
			this.tbNazev.Text = upravovany.Nazev;
			this.tbTyp.Text = upravovany.Typ;
			this.tbSpz.Text = upravovany.SPZ;
			this.tbPalivo.Text = upravovany.Palivo;
			this.tbObjem_nadrze.Text = upravovany.Objem_nadrze.ToString();
		}

		/// <summary>
		/// Ošetření uložení změn
		/// </summary>
        private void Zmena(object sender, EventArgs e) {
			this.zmena = true;
		}

        /// <summary>
        /// Tlačítko Zavřít - zavře formulář (pokud jsou uloženy změny, zeptá se, zda uložit)
        /// </summary>
		private void btnStorno_Click(object sender, EventArgs e) {
			if (MessageBox.Show("Chcete uložit změny?", "Otázka", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1) == DialogResult.Yes)
			{
					this.btnUlozit_Click(sender, e);
					return;
			}
			this.Close();
		}

        /// <summary>
        /// Tlačítko Uložit - uloží změny a zavře formulář
        /// </summary>
		private void btnUlozit_Click(object sender, EventArgs e) {
			//jsou vyplněny všechny položky?
			if (this.tbNazev.Text == "" &&
					this.tbTyp.Text == "" &&
					this.tbSpz.Text == "" &&
					this.tbPalivo.Text == "" &&
					this.tbObjem_nadrze.Text == "")
			{
					MessageBox.Show("Nejsou vyplněny všechny položky!", "Chyba");
					return;
			}

			//je objem nádrže desetinné nebo celé číslo?
			try
			{
					double.Parse(this.tbObjem_nadrze.Text);
			}
			catch (FormatException fe)
			{
					MessageBox.Show("Objem nádrže musí být celé nebo desetinné číslo!", "Chyba");
					//this.tbObjem_nadrze.Text = "0";
					this.tbObjem_nadrze.Focus();
					return;
			}

			if (this.upravit == false)
			{
					//vytvořit nový automobil
					Automobil.VytvorAutomobil(this.tbNazev.Text,
							this.tbTyp.Text,
							this.tbSpz.Text,
							this.tbPalivo.Text,
							double.Parse(this.tbObjem_nadrze.Text)
					);
			}
			else
			{
					//upravit stávající automobil
					XMLAutomobil.VytvorAutomobil(this.auto+"\\",
							this.tbNazev.Text,
							this.tbTyp.Text,
							this.tbSpz.Text,
							this.tbPalivo.Text,
							double.Parse(this.tbObjem_nadrze.Text));

					//popř. přesunout do nové složky
					try
					{
							if (!Directory.Exists(this.auto.Substring(0, this.auto.LastIndexOf("\\")) + "\\" + this.tbNazev.Text))
							{
									Directory.CreateDirectory(this.auto.Substring(0, this.auto.LastIndexOf("\\")) + "\\" + this.tbNazev.Text);
									File.Move(this.auto + "\\info.xml", this.auto.Substring(0, this.auto.LastIndexOf("\\")) + "\\" + this.tbNazev.Text + "\\info.xml");
									File.Move(this.auto + "\\jizdy.xml", this.auto.Substring(0, this.auto.LastIndexOf("\\")) + "\\" + this.tbNazev.Text + "\\jizdy.xml");
									File.Move(this.auto + "\\tankovani.xml", this.auto.Substring(0, this.auto.LastIndexOf("\\")) + "\\" + this.tbNazev.Text + "\\tankovani.xml");
									Directory.Delete(this.auto, true);
							}
					}
					catch (IOException ioe) { return; }
			}
			this.Close();
		}
	}
}
