using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace KnihaJizd
{
    /// <summary>
    /// Formulář pro zobrazení všech evidovaných jízd
    /// </summary>
    public partial class frmJizdy : Form
    {
        private List<Jizda> jizdy;
        private int vybrana = -1;
        
        /// <summary>
        /// Konstruktor
        /// </summary>
        /// <param name="jizdy">Výčet jízd</param>
        public frmJizdy(List<Jizda> jizdy)
        {
            InitializeComponent();
            this.jizdy = jizdy;

            this.Nacti();
        }

        /// <summary>
        /// Načte jízdy z výčtu do seznamu
        /// </summary>
        private void Nacti()
        {
            this.listView.Items.Clear();

            foreach (Jizda tmp in this.jizdy)
            {
                this.listView.Items.Add(
                        new ListViewItem(new string[3] {
										tmp.Datum.ToShortDateString(),
										tmp.jizdaOdkud,
										tmp.jizdaKam
								}
                        )
                );
            }
        }

        /// <summary>
        /// Kliknutí na tlačítko v panelu nástrojů
        /// </summary>
        private void toolBar_ButtonClick(object sender, ToolBarButtonClickEventArgs e)
        {
            switch (e.Button.ImageIndex)
            {
                case 0:
                    this.Pridat();
                    break;
                case 1:
                    this.Upravit();
                    break;
                case 2:
                    this.Vymazat();
                    break;
                case 3:
                    this.Zavrit();
                    break;
            }
        }

        /// <summary>
        /// Přidá novou jízdu
        /// </summary>
        private void Pridat()
        {
            frmJizdyEdit frm;

            if (this.jizdy.Count > 0)
                frm = new frmJizdyEdit(this.jizdy[this.jizdy.Count - 1].stavKoncovy, this.jizdy[this.jizdy.Count - 1].jizdaKam);
            else
                frm = new frmJizdyEdit();
            frm.ShowDialog();

            if (frm.Jizda != null)
            {
                this.jizdy.Add(frm.Jizda);
                this.jizdy.Sort(XMLJizdy.SeradJizdy);
                this.Nacti();
            }
        }

        /// <summary>
        /// Upraví zvolenou jízdu
        /// </summary>
        private void Upravit()
        {
            if (this.vybrana < 0)
            {
                MessageBox.Show("Není vybrána žádná jízda!", "Chyba");
                return;
            }

            try
            {
                frmJizdyEdit frm = new frmJizdyEdit(this.jizdy[this.vybrana]);
                frm.ShowDialog();

                this.jizdy.RemoveAt(this.vybrana);
                this.jizdy.Add(frm.Jizda);
                this.jizdy.Sort(XMLJizdy.SeradJizdy);
                this.Nacti();
            }
            catch (ArgumentOutOfRangeException aoore)
            {
                MessageBox.Show("Není vybrána žádná jízda!", "Chyba");
            }
        }

        /// <summary>
        /// Vymaže zvolenou jízdu
        /// </summary>
        private void Vymazat()
        {
            if (this.vybrana < 0)
            {
                MessageBox.Show("Není vybrána žádná jízda!", "Chyba");
                return;
            }

            if (MessageBox.Show("Opravdu vymazat zvolenou jízdu?", "Otázka", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.Yes)
            {
                try
                {
                    this.jizdy.RemoveAt(this.vybrana);
                    this.jizdy.Sort(XMLJizdy.SeradJizdy);
                    this.Nacti();
                }
                catch (ArgumentOutOfRangeException aoore)
                {
                    MessageBox.Show("Není vybrána žádná jízda!", "Chyba");
                }
            }
        }

        /// <summary>
        /// Zavře formulář
        /// </summary>
        private void Zavrit()
        {
            this.Close();
        }

        /// <summary>
        /// Vybrání jízdy v seznamu
        /// </summary>
        private void listView_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (this.listView.FocusedItem != null)
                this.vybrana = this.listView.FocusedItem.Index;
        }

        /// <summary>
        /// Vrátí upravený výčet jízd
        /// </summary>
        public List<Jizda> Jizdy
        {
            get
            {
                return this.jizdy;
            }
        }
    }
}
