using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace KnihaJizd
{
    /// <summary>
    /// Formulář pro přidání/upravení jízdy
    /// </summary>
    public partial class frmJizdyEdit : Form
    {
        private Jizda jizda;
        private bool zmena = false;
        
        /// <summary>
        /// Konstruktor - přidání první jízdy
        /// </summary>
        public frmJizdyEdit()
        {
            InitializeComponent();
            this.Text = "Přidat jízdu";

            this.jizda = null;
            this.dtDatum.Value = DateTime.Now;
        }

        /// <summary>
        /// Konstruktor - přidání další jízdy
        /// </summary>
        /// <param name="kilometry">Stav počítadla kilometrů při poslední jízdě</param>
        /// <param name="misto">Cílové místo poslední jízdy</param>
        public frmJizdyEdit(int kilometry, string misto)
        {
            InitializeComponent();
            this.Text = "Přidat jízdu";

            this.tbStavPocatecni.Text = kilometry.ToString();
            this.tbOdkud.Text = misto;
            this.jizda = null;
            this.dtDatum.Value = DateTime.Now;
        }

        /// <summary>
        /// Konstruktor - upravení jízdy
        /// </summary>
        /// <param name="jizda">Upravovaná jízda</param>
        public frmJizdyEdit(Jizda jizda)
        {
            InitializeComponent();
            this.Text = "Upravit jízdu";

            //fake s přetypováním, protože Visual studio to nechtělo brát normální cestou - už není třeba (doplnilo se public do třídy Jizda)
            this.jizda = jizda;

            this.tbStavPocatecni.Text = this.jizda.stavPocatecni.ToString();
            this.tbStavKoncovy.Text = this.jizda.stavKoncovy.ToString();
            this.tbOdkud.Text = this.jizda.jizdaOdkud;
            this.tbKam.Text = this.jizda.jizdaKam;
            this.dtDatum.Value = this.jizda.Datum;
            this.tbRidic.Text = this.jizda.Ridic;
        }

        /// <summary>
        /// Ošetření uložení změn
        /// </summary>
        private void Zmena(object sender, EventArgs e)
        {
            this.zmena = true;
        }

        /// <summary>
        /// Tlačítko Uložit - uloží jízdu do proměnné a zavře formulář
        /// </summary>
        private void mnuUlozit_Click(object sender, EventArgs e)
        {
            //jsou vyplněny všechny položky?
            if (this.tbStavPocatecni.Text == "" &&
                    this.tbStavKoncovy.Text == "" &&
                    this.tbOdkud.Text == "" &&
                    this.tbKam.Text == "" &&
                    this.tbRidic.Text == "")
            {
                MessageBox.Show("Nejsou vyplněny všechny položky!", "Chyba");
                return;
            }

            //jsou stavy kilometrů celá čísla?
            try
            {
                int.Parse(this.tbStavPocatecni.Text);
                int.Parse(this.tbStavKoncovy.Text);
            }
            catch (FormatException fe)
            {
                MessageBox.Show("Stav tachometru musí být celé číslo!", "Chyba");
                return;
            }

            //správnost zadaných kilometrů
            if (int.Parse(this.tbStavPocatecni.Text) > int.Parse(tbStavKoncovy.Text))
            {
                MessageBox.Show("Koncový stav tachometru musí být vyšší, než počáteční!", "Chyba");
                return;
            }

            Jizda tmp = new Jizda(
                    int.Parse(this.tbStavPocatecni.Text),
                    int.Parse(this.tbStavKoncovy.Text),
                    this.tbOdkud.Text,
                    this.tbKam.Text,
                    this.dtDatum.Value,
                    this.tbRidic.Text);

            this.jizda = tmp;

            this.Close();
        }

        /// <summary>
        /// Tlačítko Zavřít - zavře formulář (pokud jsou uloženy změny, zeptá se, zda uložit)
        /// </summary>
        private void mnuZavrit_Click(object sender, EventArgs e)
        {
            if (MessageBox.Show("Chcete uložit změny?", "Otázka", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1) == DialogResult.Yes)
            {
                this.mnuUlozit_Click(sender, e);
                return;
            }
            this.Close();
        }

        /// <summary>
        /// Vrátí novou/upravenou jízdu
        /// </summary>
        public Jizda Jizda
        {
            get
            {
                return this.jizda;
            }
        }
    }
}
