using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace KnihaJizd
{
    /// <summary>
    /// Hlavní formulář
    /// </summary>
    public partial class frmMain : Form
    {
        String cesta_cela;
        String cesta_data;
        private DirectoryInfo zvoleny;

        /// <summary>
        /// Konstruktor
        /// </summary>
        public frmMain()
        {
            InitializeComponent();

            this.cesta_cela = System.Reflection.Assembly.GetCallingAssembly().GetName().CodeBase;
            this.cesta_data = cesta_cela.Substring(0, cesta_cela.LastIndexOf("\\")) + "\\data\\";

            this.NactiAuta();
        }

        /// <summary>
        /// Načte dostupná auta do seznamu
        /// </summary>
        private void NactiAuta()
        {
            //oveření, zda existuje složka s daty
            if (!Directory.Exists(this.cesta_data))
            {
                //vytvoření složky
                try
                {
                    Directory.CreateDirectory(this.cesta_data);
                }
                catch (IOException ioe)
                {
                    MessageBox.Show("Nepodařilo se vytvořit složku pro data!", "Chyba");
                }
            }

            //načtení automobilů
            DirectoryInfo data = new DirectoryInfo(this.cesta_data);
            DirectoryInfo[] auta = data.GetDirectories();

            //neexistuje žádný automobil
            if (auta.Length == 0)
            {
                MessageBox.Show("Neexistuje žádné auto!", "Informace");
                return;
            }

            //výpis automobilů do listboxu
            this.lbAutomobil.Items.Clear();
            foreach (DirectoryInfo auto in auta)
            {
                this.lbAutomobil.Items.Add(auto);
            }
            this.lbAutomobil.SelectedIndex = 0;
        }

        /// <summary>
        /// Tlačítko Konec - ukončí program
        /// </summary>
        private void btnKonec_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        /// <summary>
        /// Tlačítko Přidat - přidá nový automobil
        /// </summary>
        private void btnPridat_Click(object sender, EventArgs e)
        {
            (new frmAutomobilEdit()).ShowDialog();
            this.NactiAuta();
        }

        /// <summary>
        /// Tlačítko Upravit - upraví zvolený automobil
        /// </summary>
        private void btnUpravit_Click(object sender, EventArgs e)
        {
            (new frmAutomobilEdit(this.zvoleny)).ShowDialog();
            this.NactiAuta();
        }

        /// <summary>
        /// Tlačítko Vymazat - vymaže zvolený automobil
        /// </summary>
        private void btnVymazat_Click(object sender, EventArgs e)
        {
            try
            {
                Automobil.VymazAutomobil(zvoleny);
                this.NactiAuta();
            }
            catch (NullReferenceException nre)
            {
                MessageBox.Show("Není vybrán žádný automobil!", "Chyba");
            }
        }

        /// <summary>
        /// Tlačítko Zvolit - vybraný automobil načte a zobrazí podrobnosti
        /// </summary>
        private void btnZvolit_Click(object sender, EventArgs e)
        {
            try
            {
                (new frmAutomobil(this.zvoleny)).ShowDialog();
                this.NactiAuta();
            }
            catch (NullReferenceException nre)
            {
                MessageBox.Show("Není vybrán žádný automobil!", "Chyba");
            }
        }

        /// <summary>
        /// Vybrání automobilu v seznamu
        /// </summary>
        private void lbAutomobil_SelectedIndexChanged(object sender, EventArgs e)
        {
            this.zvoleny = this.lbAutomobil.SelectedItem as DirectoryInfo;
            this.btnZvolit.Focus();
        }
    }
}
