using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace KnihaJizd
{
    /// <summary>
    /// Formulář pro zobrazení všech evidovaných tankování
    /// </summary>
    public partial class frmTankovani : Form
    {
        private List<Tankovani> tankovani;
        private int vybrana = -1;

        /// <summary>
        /// Konstruktor
        /// </summary>
        /// <param name="tankovani">Výčet tankování</param>
        public frmTankovani(List<Tankovani> tankovani)
        {
            InitializeComponent();
            this.tankovani = tankovani;

            this.Nacti();
        }

        /// <summary>
        /// Načte tankování z výčtu do seznamu
        /// </summary>
        private void Nacti()
        {
            this.listView.Items.Clear();

            foreach (Tankovani tmp in this.tankovani)
            {
                this.listView.Items.Add(
                        new ListViewItem(new string[3] {
										tmp.Datum.ToShortDateString(),
										tmp.palivoNabrano.ToString(),
										tmp.cenaCelkova.ToString() }
                        )
                );
            }
        }

        /// <summary>
        /// Kliknutí na tlačítko v panelu nástrojů
        /// </summary>
        private void toolBar_ButtonClick(object sender, ToolBarButtonClickEventArgs e)
        {
            switch (e.Button.ImageIndex)
            {
                case 0:
                    this.Pridat();
                    break;
                case 1:
                    this.Upravit();
                    break;
                case 2:
                    this.Vymazat();
                    break;
                case 3:
                    this.Zavrit();
                    break;
            }
        }

        /// <summary>
        /// Přidá nové tankování
        /// </summary>
        private void Pridat()
        {
            frmTankovaniEdit frm = new frmTankovaniEdit(this.tankovani.Count == 0);
            frm.ShowDialog();

            if (frm.Tankovani != null)
            {
                this.tankovani.Add(frm.Tankovani);
                this.tankovani.Sort(XMLTankovani.SeraditTankovani);
                this.Nacti();
            }
        }

        /// <summary>
        /// Upraví zvolené tankování
        /// </summary>
        private void Upravit()
        {
            if (this.vybrana < 0)
            {
                MessageBox.Show("Není vybrané žádné tankování!", "Chyba");
                return;
            }

            try
            {
                frmTankovaniEdit frm = new frmTankovaniEdit(this.tankovani[this.vybrana]);
                frm.ShowDialog();

                this.tankovani.RemoveAt(this.vybrana);
                this.tankovani.Add(frm.Tankovani);
                this.tankovani.Sort(XMLTankovani.SeraditTankovani);
                this.Nacti();
            }
            catch (ArgumentOutOfRangeException aoore)
            {
                MessageBox.Show("Není vybrané žádné tankování!", "Chyba");
            }
        }

        /// <summary>
        /// Vymaže zvolené tankování
        /// </summary>
        private void Vymazat()
        {
            if (this.vybrana < 0)
            {
                MessageBox.Show("Není vybrané žádné tankování!", "Chyba");
                return;
            }

            if (MessageBox.Show("Opravdu vymazat zvolené tankování?", "Otázka", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.Yes)
            {
                try
                {
                    this.tankovani.RemoveAt(this.vybrana);
                    this.tankovani.Sort(XMLTankovani.SeraditTankovani);
                    this.Nacti();
                }
                catch (ArgumentOutOfRangeException aoore)
                {
                    MessageBox.Show("Není vybrané žádné tankování!", "Chyba");
                }
            }
        }

        /// <summary>
        /// Zavře formulář
        /// </summary>
        private void Zavrit()
        {
            this.Close();
        }

        /// <summary>
        /// Vybrání tankování v seznamu
        /// </summary>
        private void listView_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (this.listView.FocusedItem != null)
                this.vybrana = this.listView.FocusedItem.Index;
        }

        /// <summary>
        /// Vrátí upravený výčet tankování
        /// </summary>
        public List<Tankovani> Tankovani
        {
            get
            {
                return this.tankovani;
            }
        }
    }
}
