using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace KnihaJizd
{
    /// <summary>
    /// Formulář pro přidání/upravení tankování
    /// </summary>
    public partial class frmTankovaniEdit : Form
    {
        private Tankovani tankovani;
        private bool zmena = false;
        private bool prvni = false;
        private int tachometrPredchozi;

        /// <summary>
        /// Konstruktor - přidání tankování
        /// </summary>
        /// <param name="prvni">Jedná se o první tankování?</param>
        public frmTankovaniEdit(bool prvni)
        {
            InitializeComponent();
            this.Text = "Přidat tankování";

            this.tankovani = null;
            this.dtDatum.Value = DateTime.Now;

            this.chPlnaNadrz.Checked = true;
            this.chPlnaNadrz.CheckStateChanged += new EventHandler(Neodskrtavat);
            if (prvni)
            {
                this.prvni = true;
                MessageBox.Show("Toto je vaše první tankování. Bohužel pro přesnou hodnotu spotřeby vypočtenou algoritmem je potřeba vždy tankovat plnou nádrž.", "Informace");
                //MessageBox.Show("Toto je vaše první nebo druhé tankování. Při prvních dvou tankování se doporučuje nabrat plnou nádrž automobilu!", "Informace");
            }

            this.vypoctiCenu(null, EventArgs.Empty);
        }

        /// <summary>
        /// Konstruktor - upravení tankování
        /// </summary>
        /// <param name="tankovani">Upravované tankování</param>
        public frmTankovaniEdit(Tankovani tankovani)
        {
            InitializeComponent();
            this.Text = "Upravit tankování";

            this.tankovani = tankovani;

            this.tbStavTachometru.Text = this.tankovani.stavTachometru.ToString();
            this.tbPalivoNabrano.Text = this.tankovani.palivoNabrano.ToString();
            this.tbCenaCelkova.Text = this.tankovani.cenaCelkova.ToString();
            this.chPlnaNadrz.Checked = this.tankovani.plnaNadrz;
            this.dtDatum.Value = this.tankovani.Datum;
            this.tbRidic.Text = this.tankovani.Ridic;

            this.chPlnaNadrz.Checked = true;
            this.chPlnaNadrz.CheckStateChanged += new EventHandler(Neodskrtavat);

            this.vypoctiCenu(null, EventArgs.Empty);
        }

        /// <summary>
        /// Při odškrtnutí zobrazí varovné upozornění - po vypilování druhého algoritmu nebude používáno
        /// </summary>
        private void Neodskrtavat(object sender, EventArgs e)
        {
            if (this.chPlnaNadrz.Checked) return;
            MessageBox.Show("Součastný algoritmus neumožňuje počítat spotřebu jinak, než tankováním do plné nádrže!", "Informace");
            this.chPlnaNadrz.Checked = true;
            //MessageBox.Show("POZOR: toto je vaše první nebo druhé tankování. Abychom dosáhli co nejpřesnějších statistik, je nutné při prvním a druhém tankování natankovat plnou nádrž!", "Informace");
            //MessageBox.Show("Pokud nechcete brát plnou nádrž, zadejte místo objemu nabraného paliva Váš ODHAD zůstatku paliva před tankováním!", "Informace");
        }

        /// <summary>
        /// Ošetření uložení změn
        /// </summary>
        private void Zmena(object sender, EventArgs e)
        {
            this.zmena = true;
        }

        /// <summary>
        /// Tlačítko Uložit - uloží tankování do proměnné a zavře formulář
        /// </summary>
        private void mnuUlozit_Click(object sender, EventArgs e)
        {
            //jsou vyplněny všechny položky
            if (this.tbStavTachometru.Text == "" &&
                    this.tbPalivoNabrano.Text == "" &&
                    this.tbCenaCelkova.Text == "" &&
                    this.tbRidic.Text == "")
            {
                MessageBox.Show("Nejsou vyplněny všechny položky!", "Chyba");
                return;
            }

            //jsou stavy kilometrů celá čísla?
            try
            {
                int.Parse(this.tbStavTachometru.Text);
            }
            catch (FormatException fe)
            {
                MessageBox.Show("Stav tachometru musí být celé číslo!", "Chyba");
                return;
            }

            //jsou nabrané litry a cena desetinná čísla?
            try
            {
                double.Parse(this.tbPalivoNabrano.Text);
                double.Parse(this.tbCenaCelkova.Text);
            }
            catch (FormatException fe)
            {
                MessageBox.Show("Objem nabraného paliva a cena musí být celá nebo desetinná čísla!", "Chyba");
                return;
            }

            Tankovani tmp = new Tankovani(
                    int.Parse(this.tbStavTachometru.Text),
                    double.Parse(this.tbPalivoNabrano.Text),
                    double.Parse(this.tbCenaCelkova.Text),
                    this.chPlnaNadrz.Checked,
                    this.dtDatum.Value,
                    this.tbRidic.Text);

            this.tankovani = tmp;

            this.Close();
        }

        /// <summary>
        /// Tlačítko Zavřít - zavře formulář (pokud jsou uloženy změny, zeptá se, zda uložit)
        /// </summary>
        private void mnuZavrit_Click(object sender, EventArgs e)
        {
            if (MessageBox.Show("Chcete uložit změny?", "Otázka", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1) == DialogResult.Yes)
            {
                this.mnuUlozit_Click(sender, e);
                return;
            }
            this.Close();
        }

        /// <summary>
        /// Při změně polí pro objem paliva a celkovou cenu vypočte cenu za 1 litr paliva
        /// </summary>
        private void vypoctiCenu(object sender, EventArgs e)
        {
            try
            {
                double cena = double.Parse(this.tbCenaCelkova.Text);
                double objem = double.Parse(this.tbPalivoNabrano.Text);

                this.lblCenaLitr.Text = Math.Round((cena / objem), 2).ToString();
            }
            catch (FormatException fe) { this.lblCenaLitr.Text = "0"; }
            finally { this.Zmena(sender, e); }
        }

        /// <summary>
        /// Vrátí nové/upravené tankování
        /// </summary>
        public Tankovani Tankovani
        {
            get
            {
                return this.tankovani;
            }
        }
    }

}
